/* **********************************************************
 * Copyright 2011-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.bindings;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.StructValue;

/**
 * Extracts value for <code>StructValue</code> field and converts it to
 * Java representation.
 */
public class StructValueExtractor {
    private final StructType structType;
    private final StructValue structValue;
    private final TypeConverter converter;

    /**
     * Constructor.
     *
     * @param structValue value for vAPI structure
     * @param structType  type of the structure value
     * @param converter   converter between API runtime types and bindings types
     */
    public StructValueExtractor(StructValue structValue,
                                StructType structType,
                                TypeConverter converter) {
        this.structType = structType;
        this.structValue = structValue;
        this.converter = converter;
    }

    /**
     * Returns the value for particular field of the structure represented
     * as non-primitive Java type.
     *
     * @param fieldName  name of a field in the structure
     * @param <T>        type of the result
     * @return <code>Object</code> representing the value
     */
    public <T> T valueForField(String fieldName) {
        Type fieldType = structType.getField(fieldName);
        return converter.<T>convertToJava(structValue.getField(fieldName),
                                          fieldType);
    }

}
