/* *********************************************************************************
 * Copyright (c) 2018, 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************************************/

package com.vmware.vapi.internal.bindings;

import java.util.Collection;

import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.internal.bindings.Stub;

/**
 * Data structure which holds required parameters for {@link Stub} invoke methods.
 */
public class StubParameters {
    private final MethodIdentifier methodId;
    private final MethodIdentifier taskMethodId;
    private final StructType inputType;
    private final Type outputType;
    private final Collection<Type> errorTypes;

    public StubParameters(MethodIdentifier methodId,
                          MethodIdentifier taskMethodId,
                          StructType inputType,
                          Type outputType,
                          Collection<Type> errorTypes) {
        this.methodId = methodId;
        this.taskMethodId = taskMethodId;
        this.inputType = inputType;
        this.outputType = outputType;
        this.errorTypes = errorTypes;
    }

    public MethodIdentifier getMethodId() {
        return methodId;
    }

    public MethodIdentifier getTaskMethodId() {
        return taskMethodId;
    }

    public StructType getInputType() {
        return inputType;
    }

    public Type getOutputType() {
        return outputType;
    }

    public Collection<Type> getErrorTypes() {
        return errorTypes;
    }

}
