/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * ByteArrayBinaryConverter.java --
 *
 *      Convert binary type to byte array
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert binary type to byte array.
 */
public final class ByteArrayBinaryConverter implements
        PrimitiveConverter<BlobValue> {

    @Override
    public byte[] fromValue(BlobValue value) {
        return value.getValue();
    }

    @Override
    public BlobValue toValue(Object primitiveBinding) {
        byte[] bind = ConvertUtil.narrowType(primitiveBinding, byte[].class);
        return new BlobValue(bind);
    }

}
