/* **********************************************************
 * Copyright 2012-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

/*
 * ConvertUtil.java --
 *
 *      Utility for converter implementations
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.bindings.convert.ConverterException;

/**
 * Utility for converter implementations.
 */
public final class ConvertUtil {

    /**
     * Cast the specified object to the given class.
     *
     * @param obj            object
     * @param expectedClass  expected class of the object; must not be null
     * @param <T> target type
     * @return the same object casted as the expected type
     * @throws ConverterException if the object is null or is not an instance of the
     *                       specified class
     */
    public static <T> T narrowType(Object obj, Class<T> expectedClass) {
        if (!expectedClass.isInstance(obj)) {
            String actualType = (obj != null) ?
                    obj.getClass().getCanonicalName() : "null";
            throw new ConverterException(
                    "vapi.bindings.typeconverter.unexpected.java.class",
                    expectedClass.getCanonicalName(),
                    actualType);
        }
        return expectedClass.cast(obj);
    }


}
