/* **********************************************************
 * Copyright 2012 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JavaLangDoubleDoubleConverter.java --
 *
 *      Convert double type to java.lang.Double
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert double type to java.lang.Double.
 */
public final class JavaLangDoubleDoubleConverter implements
        PrimitiveConverter<DoubleValue> {

    @Override
    public Double fromValue(DoubleValue value) {
        return Double.valueOf(value.getValue());
    }

    @Override
    public DoubleValue toValue(Object primitiveBinding) {
        Double bind = ConvertUtil.narrowType(primitiveBinding, Double.class);
        return new DoubleValue(bind);
    }

}
