/* **********************************************************************
 * Copyright 2013-2014 VMware, Inc. All rights reserved.
 *      --VMware Confidential
 * *********************************************************************/
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;

/**
 * Convert id type to java.lang.String.
 */
public final class JavaLangStringIdConverter implements PrimitiveConverter<StringValue> {

    @Override
    public Object fromValue(StringValue value) {
        return value.getValue();
    }

    @Override
    public StringValue toValue(Object primitiveBinding) {
        String bind = ConvertUtil.narrowType(primitiveBinding, String.class);
        return new StringValue(bind);
    }
}
