/* **********************************************************
 * Copyright (c) 2012-2013, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JavaUtilSetSetConverter.java --
 *
 *      Convert set type to java.util.Set
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import java.util.HashSet;
import java.util.Set;

import com.vmware.vapi.bindings.convert.ConverterException;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.bindings.TypeConverter.ConversionContext;
import com.vmware.vapi.internal.bindings.convert.UniTypeConverter;

/**
 * Convert set type to java.util.Set.
 */
public final class JavaUtilSetSetConverter implements
        UniTypeConverter<ListValue, SetType> {

    @Override
    public Object fromValue(ListValue value, SetType declaredType,
            TypeConverter typeConverter) {
        Set<Object> binding = new HashSet<Object>();
        Type elemType = declaredType.getElementType();
        for (DataValue elemValue : value) {
            Object elem = typeConverter.convertToJava(elemValue, elemType);
            if (binding.contains(elem)) {
                throw new ConverterException(
                        "vapi.bindings.typeconverter.set.duplicate.element");
            }
            binding.add(elem);
        }
        return binding;
    }

    @Override
    public DataValue toValue(Object binding,
                             SetType declaredType,
                             TypeConverter typeConverter,
                             ConversionContext cc) {
        @SuppressWarnings("unchecked")
        final Set<Object> set = ConvertUtil.narrowType(binding, Set.class);
        Type elemType = declaredType.getElementType();
        ListValue setValue = new ListValue();
        for (Object elem : set) {
            DataValue elemValue = typeConverter
                    .convertToVapi(elem, elemType, cc);
            setValue.add(elemValue);
        }
        return setValue;
    }
}
