/* **********************************************************
 * Copyright 2013-2015 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.data;

import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.DataValue;

/**
 * Implementations of this interface are enforcing static (defined in the IDL) or
 * dynamic constraints.
 */
public interface ConstraintValidator {

    /**
     * Validates the constraint imposed by this validator.
     *
     * @param dataValue data value to validate; must not be <code>null</code>
     * @throws ConstraintValidationException if the constraint is not satisfied
     */
    void validate(DataValue dataValue);
}
