/* **********************************************************
 * Copyright (c) 2015-2017, 2020 VMware, Inc.All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol;

import com.vmware.vapi.bindings.Service;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.client.Configuration;
import com.vmware.vapi.internal.bindings.TypeConverter;
import com.vmware.vapi.internal.client.Protocol;
import com.vmware.vapi.protocol.JsonProtocolConnectionFactory;
import com.vmware.vapi.protocol.ProtocolConnection;
import com.vmware.vapi.protocol.ProtocolConnectionFactory;

public class JsonRpcOverHttp implements Protocol {
    private JsonRpcOverHttp() {

    }

    @Override
    public ApiProviderCardinality getApiProviderCardinality() {
        return ApiProviderCardinality.SINGLE;
    }

    @Override
    public ProtocolConnection getProtocolConnection(String url, Configuration config) {
        // TODO: configurable factory to use
        ProtocolConnectionFactory factory = new JsonProtocolConnectionFactory();
        // TODO: fetch HttpConfig and ClientConfig from the config
        return factory.getHttpConnection(url, null, null);
    }

    public static Protocol getInstance() {
        return new JsonRpcOverHttp();
    }

    @Override
    public <T extends Service> TypeConverter getTypeConverter(StubConfigurationBase stubConfig, Class<T> vapiIface) {
        return null;  // use default
    }
}
