/* **********************************************************
 * Copyright (c) 2016, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.vmware.vapi.internal.bindings.OperationDef;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest.HttpMethod;
import com.vmware.vapi.internal.util.Validate;

/**
 * Adapter for static bindings generated REST metadata ({@link OperationDef}).
 */
public class BindingsOperationRestMetadata implements OperationRestMetadata {
    private final OperationDef operationDef;

    public BindingsOperationRestMetadata(OperationDef operationDef) {
        Validate.notNull(operationDef);
        this.operationDef = operationDef;
    }

    @Override
    public Map<String, String> getPathVariablesToFieldNames() {
        if (operationDef.getPathVariableInfo() == null) {
            return Collections.emptyMap();
        }
        return operationDef.getPathVariableInfo();
    }

    @Override
    public Map<String, String> getRequestParamsToFieldNames() {
        if (operationDef.getRequestParamInfo() == null) {
            return Collections.emptyMap();
        }
        return operationDef.getRequestParamInfo();
    }

    @Override
    public Map<String, String> getRequestHeadersToFieldNames() {
        if (operationDef.getHeadersInfo() == null) {
            return Collections.emptyMap();
        }
        return operationDef.getHeadersInfo();
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(operationDef.getHttpMethod());
    }

    @Override
    public String getUrlTemplate() {
        return operationDef.getUrlTemplate();
    }

    @Override
    public String getRequestBodyFieldName() {
        return operationDef.getRequestBodyFieldName();
    }

    @Override
    public String getAccept() {
        return operationDef.getAcceptHeaderValue();
    }

    @Override
    public String getContentType() {
        return operationDef.getContentTypeHeaderValue();
    }

    @Override
    public Map<String, List<String>> getFixedHeaders() {
        // TODO: rest native: support these?
        return Collections.emptyMap();
    }
}
