/* **********************************************************
 * Copyright (c) 2016, 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.vmware.vapi.client.exception.MessageProtocolException;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.protocol.common.DataValueBuilder;
import com.vmware.vapi.internal.protocol.common.DirectDeserializer;

/**
 * For <b>REST Native</b> response processing.
 */
public class DefaultBodyConverter implements BodyConverter {
    private final DirectDeserializer deserializer;

    public DefaultBodyConverter(DirectDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public DataValue getResult(String serviceId,
                               String operationId,
                               HttpResponse response) {
        DataValueBuilder resultBuilder = new DataValueBuilder();
        InputStream stream = null;
        byte[] rawResponse = response.getBody();
        if (rawResponse == null || rawResponse.length == 0) {
            // When deserializing JSON if the raw response is null or empty we assume void value
            // In case of octet-stream deserialization empty raw response is valid empty file
            return VoidValue.getInstance();
        }
        stream = new ByteArrayInputStream(rawResponse);
        try {
            deserializer.deserialize(resultBuilder, stream);
        } catch (IOException e) {
            throw new MessageProtocolException("JSON deserialization failed.", e);
        }

        return resultBuilder.getResult();
    }
}
