/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import java.util.List;
import java.util.Map;

import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest.HttpMethod;

/**
 * {@link RequestBuilder} implementation which builds HTTP request
 * using provided metadata for the invocation.
 */
public class DefaultRequestBuilder implements RequestBuilder {
    private final RestMetadataBasedHttpRequestBuilder httpRequestBuilder;
    private final OperationRestMetadata operationMetadata;
    private final String baseUrl;

    public DefaultRequestBuilder(RestMetadataBasedHttpRequestBuilder httpRequestBuilder,
                                 OperationRestMetadata operationRestMetadata,
                                 String baseUrl) {
        this.httpRequestBuilder = httpRequestBuilder;
        this.operationMetadata = operationRestMetadata;
        this.baseUrl = baseUrl;
    }

    @Override
    public String buildUrl(StructValue input) {
        return httpRequestBuilder.buildAbsoluteTargetUrl(input, baseUrl);
    }

    @Override
    public HttpMethod getMethod() {
        return operationMetadata.getMethod();
    }

    @Override
    public Map<String, List<String>> buildHeaders(StructValue input) {
        return httpRequestBuilder.buildHeaders(input);
    }

    @Override
    public byte[] buildBody(StructValue input) {
        // no body
        return null;
    }

    protected RestMetadataBasedHttpRequestBuilder getHttpRequestBuilder() {
        return httpRequestBuilder;
    }
}
