/* **********************************************************
 * Copyright (c) 2015-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

/**
 * Provider for REST metadata about API operations.
 */
public interface OperationRestMetadataProvider {

   /**
    * Returns REST metadata for the specified operation.
    *
    * @param serviceId should be in <i>canonical</i> form; must not be {@code null}
    * @param operationId should be in <i>canonical</i> form; must not be {@code null}
    * @return REST metadata for the the operation or {@code null} if such is not available
    */
   public OperationRestMetadata getRestMetadata(String serviceId, String operationId);
}
