/* **********************************************************
 * Copyright (c) 2015-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import java.util.List;
import java.util.Map;

import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest.HttpMethod;

/**
 * Builder for various pieces of <em>HTTP</em> request, like
 * URL, HTTP method, headers and body.
 */
public interface RequestBuilder {

    /**
     * Build HTTP request URL using vAPI operation invocation data.
     *
     * @param input of vAPI operation invocation.
     * @return HTTP request URL. Must not be <code>null</code>.
     */
    public String buildUrl(StructValue input);

    /**
     * @return HTTP request method. Must not be <code>null</code>.
     */
    public HttpMethod getMethod();

    /**
     * Build HTTP request headers using vAPI operation invocation data.
     *
     * @param input of vAPI operation invocation.
     * @return map of header names to header values. Must not be <code>null</code>.
     */
    public Map<String, List<String>> buildHeaders(StructValue input);

    /**
     * Build HTTP request body using vAPI operation invocation data.
     *
     * @param input of vAPI operation invocation.
     * @return HTTP request body. Must not be <code>null</code>.
     */
    public byte[] buildBody(StructValue input);
}
