/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;

/**
 * Provides a method for invoking an API through an HTTP request.
 */
public interface RequestExecutor {
    /**
     * Invokes an API through an HTTP request asynchronously, parses the
     * response and reports the result in the specified {@code asyncHandle}.
     *
     * @param serviceId service identifier; must not be {@code null}
     * @param operationId operation identifier; must not be {@code null}
     * @param request that will be processed; must not be {@code null}
     * @param executionContext for the operation invocation; must not be
     *        {@code null}
     * @param asyncHandle handle used to asynchronously "return" the result or
     *        error of the invocation; must not be {@code null}
     */
    void execute(String serviceId,
                 String operationId,
                 HttpRequest request,
                 ExecutionContext executionContext,
                 AsyncHandle<MethodResult> asyncHandle);
}
