/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.internal.protocol.client.rpc.RestTransport;

/**
 * A factory for {@link RequestExecutor} objects.
 */
public interface RequestExecutorFactory {
    /**
     * Creates a {@link RequestExecutor} with the specified parameters.
     *
     * @param transport the transport which the executor will use for issuing
     *        HTTP requests with
     * @param parser the parser which the executor will use for parsing the
     *        HTTP responses with
     * @return the new {@link RequestExecutor}
     */
    RequestExecutor createRequestExecutor(RestTransport transport,
                                          ResponseParser parser);
}
