/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest;

import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;

/**
 * <em>HTTP</em> response parser.
 */
public interface ResponseParser {
    /**
     * Parse HTTP response, converting into a {@link MethodResult} representing
     * the operation invocation result.
     *
     * @param response
     * @param serviceId
     * @param operationId
     * @return parsed HTTP response; must not be <code>null</code>.
     */
    public MethodResult parse(String serviceId,
                              String operationId,
                              HttpResponse response);
}
