/* **********************************************************
 * Copyright (c) 2017, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.vmware.vapi.internal.util.Validate;

/**
 * Authentication request processor which appends custom HTTP header
 * to the request for authentication purposes.
 *
 * <p>The value of the appended header is the authentication token, without
 * any prefix, suffix or additional processing.
 */
public class CustomHeaderAuthenticationAppender extends HeaderAuthenticationAppenderBase {
    private final String headerName;

    /**
     * Constructor.
     * @param headerName name of the custom HTTP header to be used for the
     *        authentication token
     */
    public CustomHeaderAuthenticationAppender(String headerName) {
        Validate.notEmpty(headerName);
        this.headerName = headerName;
    }

    @Override
    protected String getHeaderName() {
        return headerName;
    }

    @Override
    protected String getHeaderValue(String token) {
        return token;
    }
}
