/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest.authn;

import com.vmware.vapi.core.ExecutionContext.SecurityContext;
import com.vmware.vapi.internal.protocol.client.rpc.HttpRequest;

/**
 * Provides a method to manipulate HTTP requests prior to sending so that they
 * contain authorization information.
 */
public interface HttpRequestAuthorizer {
    /**
     * Modifies the specified {@code httpRequest} with the information supplied
     * in the {@code securityContext} so that it appears as authorized to the
     * server.
     *
     * @param httpRequest the request to modify
     * @param securityContext the context containing the authorization
     *        information
     */
    void authorize(HttpRequest httpRequest, SecurityContext securityContext);
}
