/* **********************************************************
 * Copyright (c) 2015-2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rest.authn;

import java.nio.charset.StandardCharsets;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vapi.protocol.HttpConfiguration;

/**
 * Utility class for fetching OAuth token from HTTP URL using HTTP Basic
 * Authentication.
 *
 * <p><b>WARNING: </b> This class is subject to change.
 */
// TODO: need to revisit; this class is really not well designed/coded/tested (its prototype
//       coming from the vca-sdk demo) and doesn't fit well in the PDK as it stands right
//       now
public class OauthTokenProvider extends HttpTokenProviderBase {
   private static final Logger logger =
         LoggerFactory.getLogger(OauthTokenProvider.class);

   /**
    * Constructor.
    *
    * @param url target URL to be used for obtaining OAuth token
    * @param httpConfig HTTP configuration for executing request to the URL; may be {@code null}
    */
   public OauthTokenProvider(String url, HttpConfiguration httpConfig) {
       super(url, httpConfig);
   }

   @Override
   protected HttpUriRequest buildTokenRequest(String username, String password) {
       logger.debug("Getting oaut token.");
       HttpPost request = new HttpPost(getUrl());
       String authn = String.format("%s:%s", username, new String(password));
       String authnBase64encoded = Base64.encodeBase64String(authn
             .getBytes(StandardCharsets.UTF_8));
       BasicHeader header =
             new BasicHeader(HttpHeaders.AUTHORIZATION,
                   String.format("Basic %s",
                         authnBase64encoded));
       request.addHeader(header);
       header = new BasicHeader("Accept", "application/json;version=5.7");
       request.addHeader(header);
       return request;
   }

   @Override
   protected String extractToken(HttpResponse response) {
      Header[] headers = response.getHeaders("vchs-authorization");
      if (headers != null) {
         for (Header header : headers) {
            for (HeaderElement headerElement : header.getElements()) {
               if (headerElement.getName() != null) {
                  return headerElement.getName();
               }
            }
         }
      }
      return null;
   }

    @Override
    protected HttpUriRequest buildTokenRequest(String accessKey) throws Exception {
        throw new UnsupportedOperationException("This method has no implementation.");
    }
}
