/* **********************************************************
 * Copyright (c) 2015-2016, 2018-2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc;

/**
 * Defines a simplified interface to HTTP response abstraction for use by the REST client code. This
 * can be implemented over different HTTP libraries.
 */
public interface HttpResponse extends com.vmware.vapi.core.HttpResponse, AutoCloseable {

    /**
     * Fetches the content of the response body.
     *
     * <p>This method reads the stream from the underlying HTTP response and must
     * be called only once per response. There is no guarantee that subsequent
     * invocations of this method will be successful, since usually the underlying
     * response is streamed from the socket and cannot be read second time.
     *
     * @return body of the HTTP response or {@code null} if there is none
     * @throws RuntimeException if obtaining the body fails.
     */
    public byte[] getBody();

    /**
     * Releases any resources associated with this HTTP response.
     *
     * <p>This method can be used to release the resources even if the content
     * of the response has not been consumed via {@link #getBody()}.
     *
     * {@inheritDoc}
     */
    @Override
    public void close() throws Exception;
}
