/* **********************************************************
 * Copyright (c) 2015-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc;

import java.io.Closeable;

import com.vmware.vapi.core.ExecutionContext;

public interface RestTransport extends Closeable {

    /**
     * Executes an HTTP request asynchronously and reports the result in the
     * specified <code>responseHandler</code>.
     *
     * @param request HTTP request to execute
     * @param responseHandler callback for the result of the request execution; must not
     *        be {@code null}
     * @param ctx context of the invocation execution
     * @throws IllegalArgumentException if either the URL or method of the HTTP request are
     *         {@code null}.
     */
    void execute(HttpRequest request,
                 HttpRequest.HttpResponseHandler responseHandler,
                 ExecutionContext ctx);
}