/* **********************************************************
 * Copyright (c) 2015-2016, 2018-2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;

import com.vmware.vapi.internal.protocol.client.rpc.HttpResponse;
import com.vmware.vapi.internal.util.io.IoUtil;

//TODO add unit tests, logging and exception handling.
/**
 * Apache HTTP library based implementation of {@link HttpResponse}.
 * <p>
 * This class is not thread safe and thus instances of it must not be shared across threads.
 */
// TODO: rename to HttpResponseImpl; not ready to do this yet, because we first
//       need to get the apache response processing logic out of this class
public class ApacheHttpResponse implements HttpResponse {
    private final org.apache.http.HttpResponse response;

    /**
     * Constructor.
     *
     * @param response of HTTP request that is proxied. Must not be <code>null</code>.
     */
    public ApacheHttpResponse(org.apache.http.HttpResponse response) {
        this.response = response;
    }

    @Override
    public int getStatusCode() {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            return statusLine.getStatusCode();
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public List<String> getHeader(String headerName) {
        List<String> result = new ArrayList<>();
        for (Header h : response.getHeaders(headerName)) {
            result.add(h.getValue());
        }
        return result;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        Map<String, List<String>> headers = new HashMap<>();
        for (Header header : response.getAllHeaders()) {
            Utils.addListEntryToMapOfLists(header.getName(), header.getValue(), headers);
        }
        return headers;
    }

    @Override
    public byte[] getBody() {
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStream contentStream = entity.getContent()) {
                return IoUtil.readAll(contentStream);
            } catch (IllegalStateException e) {
                // TODO
                throw new RuntimeException(e);
            } catch (IOException e) {
                // TODO
                throw new RuntimeException(e);
            }
        } else {
            return null;
        }
    }

    @Override
    public void close() throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        entity.getContent().close();
    }
}
