/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

import javax.net.ssl.X509TrustManager;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Implementation bypassing the certificate path validation check normally
 * performed during an SSL-handshake. It allows establishing SSL-connections
 * without a trust-store.
 */
class TrustAllX509TrustManager implements X509TrustManager {
    private static Logger logger =
            LoggerFactory.getLogger(TrustAllX509TrustManager.class);
    private static X509Certificate[] acceptedIssuers = new X509Certificate[] {};

    @Override
    public void checkClientTrusted(X509Certificate[] cert, String authType)
            throws CertificateException {
        warn();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] cert, String authType)
            throws CertificateException {
        warn();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return acceptedIssuers;
    }

    private static void warn() {
        logger.warn("Skipped the validation of a certificate chain due to "
                  + "configuration policy. Your connection is not secure!");
    }
}
