/* **********************************************************
 * Copyright 2014-2015, 2019 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.client.rpc.http;

import java.io.IOException;
import java.security.cert.X509Certificate;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

import com.vmware.vapi.internal.util.Validate;

/**
 * Since Apache HTTP client 4.4 the X509HostnameVerifier is deprecated and the
 * {@link HostnameVerifier} interface should replace it. However we still have
 * consumers at Apache HTTP client 4.3.x that can't use the
 * {@link HostnameVerifier} (there methods using it are made available at 4.4),
 * so we are still using the deprecated one. Once all consumers migrat to 4.4
 * and newer it would be safe to replace the {@link X509HostnameVerifier} with
 * the {@link HostnameVerifier}.
 *
 * @deprecated the {@link X509HostnameVerifier} is deprecated, should be
 *             replaced by {@link HostnameVerifier}
 */
@Deprecated
class VapiHostnameVerifier implements org.apache.http.conn.ssl.X509HostnameVerifier {
    private final org.apache.http.conn.ssl.X509HostnameVerifier delegate;

    VapiHostnameVerifier(org.apache.http.conn.ssl.X509HostnameVerifier delegate) {
        Validate.notNull(delegate);
        this.delegate = delegate;
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        return delegate.verify(adjust(hostname), session);
    }

    @Override
    public void verify(String host, SSLSocket ssl) throws IOException {
        delegate.verify(adjust(host), ssl);
    }

    @Override
    public void verify(String host, X509Certificate cert) throws SSLException {
        delegate.verify(adjust(host), cert);
    }

    @Override
    public void verify(String host, String[] cns, String[] subjectAlts)
            throws SSLException {
        delegate.verify(adjust(host), cns, subjectAlts);
    }

    String adjust(String hostname) {
        return SslClientUtil.stripHostnameBrackets(hostname);
    }
}
