/* **********************************************************
 * Copyright (c) 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import java.io.IOException;
import java.io.InputStream;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient.ResponseCallback;
import com.vmware.vapi.protocol.common.http.HttpConstants;

/**
 * This class is responsible for handling the {@code HttpResponse} content
 * received after {@code HttpClient::invoke}. Contents are handled differently
 * based on the {@code ContentType}.
 */
public class BioResponseContentHandler {

    private String contentType;
    private ResponseCallback cb;
    private BioResponseHandlingStrategy handleStrategy;

    public BioResponseContentHandler(String contentType, ResponseCallback cb) {
        this.contentType = contentType;
        this.cb = cb;
        this.handleStrategy = createStrategy();
    }

    private BioResponseHandlingStrategy createStrategy() {
        switch (contentType) {
        /*
         * TODO case HttpConstants.CONTENT_TYPE_CLEAN_STREAM_JSON:
         */
        case HttpConstants.CONTENT_TYPE_STREAM_JSON:
            return new BioStreamingResponseHandlingStrategy();
        case HttpConstants.CONTENT_TYPE_FRAMED:
            return new BioFramedResponseHandlingStrategy();
        default:
            return new BioSingleResponseHandlingStrategy();
        }
    }

    /**
     * Processes the {@code InputStream} content based on an underlying
     * strategy, determined by the {@code ContentType}. The {@code InputStream}
     * is closed by the strategy.
     *
     * @param content - must not be {@code null}
     * @param abortHandle - can be {@code null}
     * @param uri - can be {@code null}
     * @throws IOException
     */
    public void handleResposne(InputStream content,
                               AbortHandle abortHandle,
                               String uri)
            throws IOException {
        handleStrategy.handleContent(content, cb, abortHandle, uri);
    }
}
