/* **********************************************************
 * Copyright (c) 2020 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.client.rpc.http.handle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.vmware.vapi.internal.core.abort.AbortHandle;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient;
import com.vmware.vapi.internal.protocol.client.rpc.CorrelatingClient.ResponseCallback;
import com.vmware.vapi.internal.util.io.IoUtil;

public class BioSingleResponseHandlingStrategy
        implements BioResponseHandlingStrategy {

    @Override
    public void handleContent(InputStream content,
                              ResponseCallback cb,
                              AbortHandle abortHandle,
                              String uri)
            throws IOException {
        try {
            byte[] frame = IoUtil.readAll(content);
            cb.received(new ByteArrayInputStream(frame),
                        CorrelatingClient.NO_OP_CONTROL);
        } finally {
            IoUtil.silentClose(content);
        }
    }
}
