/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.common;

import java.io.IOException;
import java.io.OutputStream;

import com.vmware.vapi.data.DataValue;

/**
 * Serializer for {@code DataValue}.
 *
 * <p>This serializer is "direct" in the sense that it does not use any additional
 * metadata about the expected structure or the field types of the {@code DataValue}
 * being serialized. It is completely driven by the {@code DataValue} itself.
 *
 * <p>Concrete implementations might use different formats for the
 * byte stream representation of the {@code DataValue} (e.g. JSON, XML,
 * or some binary format). The structure of the serialized {@code DataValue}
 * might differ, depending on the capabilities of the chosen format.
 */
public interface DirectSerializer {

    /**
     * Serializes the provided {@code DataValue} to the output stream.
     * @param value {@code DataValue} to serialize
     * @param outputStream stream to write the serialized result to
     * @param serializerConfig additional configuration for this serializer
     * @throws IOException
     */
    void serialize(DataValue value,
                   OutputStream outputStream,
                   SerializerConfig serializerConfig) throws IOException;
}