/* **********************************************************
 * Copyright (c) 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.common;

/**
 * Configuration for {@link DirectSerializer}.
 */
public class SerializerConfig {
    private final boolean prettyPrint;
    private final boolean closeRequired;

    public SerializerConfig(boolean prettyPrint) {
        this(prettyPrint, true);
    }

    public SerializerConfig(boolean prettyPrint, boolean closeRequired) {
        this.prettyPrint = prettyPrint;
        this.closeRequired = closeRequired;
    }

    /**
     * Gets whether the output should be formatted.
     */
    public boolean isPrettyPrint() {
        return prettyPrint;
    }

    /**
     * Gets whether the output stream has to be closed.
     */
    public boolean isCloseRequired() {
        return closeRequired;
    }
}
