/* **********************************************************
 * Copyright 2013, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.common.http.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import com.vmware.vapi.internal.util.Validate;

/**
 * Handle to an input source, which wraps a {@link java.io.InputStream}.
 * Logically this handle represents the complete input source. When the
 * underlying stream is depleted, the handle would return
 * {@link BinaryInput#NO_DATA_PERMANENT}. Because the underlying I/O API is
 * blocking, this handle will never return {@link BinaryInput#NO_DATA_TEMPORARY}
 * but will block waiting for more data.
 * <p>
 * <i>Thread-safety:</i> not thread-safe.
 * </p>
 */
public final class InputStreamBinaryInput implements BinaryInput {

    private final DataInputStream inp;

    public InputStreamBinaryInput(InputStream inp) {
        Validate.notNull(inp);
        this.inp = new DataInputStream(inp);
    }

    @Override
    public int read() throws IOException {
        return inp.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return inp.read(b, off, len);
    }

}
