/* **********************************************************
 * Copyright 2012, 2020 VMware, Inc. All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * JsonApiResponse.java --
 *
 *      Class to represent a INVOKE_METHOD JSON RPC 2.0
 *      response.
 */

package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.core.MethodResult;

public final class JsonApiResponse extends JsonBaseResponse {
    private MethodResult result;

    public JsonApiResponse(String id, MethodResult result) {
        super(id);
        this.result = result;
    }

    public MethodResult getResult() {
        return result;
    }

    public void setResult(MethodResult result) {
        this.result = result;
    }

    /**
     * Indicates if this is the last response in a stream.
     */
    public boolean isLast() {
        return result == MethodResult.EMPTY || result.getError() != null;
    }
}
