/* **********************************************************
 * Copyright (c) 2013-2014, 2016-2017, 2019 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.common.json;

import java.io.IOException;
import java.io.InputStream;

import com.fasterxml.jackson.core.JsonParseException;
import com.vmware.vapi.internal.protocol.common.json.JsonConstants.RequestType;
import com.vmware.vapi.protocol.common.json.JsonRpcDeserializer;

/**
 * JSON deserializer for vAPI requests, responses and runtime objects.
 */
public interface JsonDeserializer extends JsonRpcDeserializer {

    /**
     * Method to deserialize a JSON-RPC 2.0 response
     *
     * @param jsonResponse A JSON-RPC 2.0 response.
     * @param responseType Enum indicating the type of response
     * @return An instance of JsonBaseResponse or one of the extended classes
     * @throws JsonInvalidDataValueException
     */
    JsonBaseResponse responseDeserialize(InputStream jsonResponse,
                                         RequestType responseType);

    /**
     * Method to deserialize a JSON-RPC 2.0 request.
     *
     * @param jsonRequest Incoming JSON-RPC 2.0 request
     * @return Instance of JsonApiRequest
     * @throws JsonInvalidMethodParamsException
     * @throws JsonInvalidRequest
     * @throws JsonInvalidDataValueException
     * @throws JsonInvalidMethodException
     * @throws JsonParseException
     * @throws IOException
     */
    JsonApiRequest requestDeserialize(String jsonRequest)
            throws JsonInvalidMethodParamsException,
                   JsonInvalidRequest,
                   JsonInvalidDataValueException,
                   JsonInvalidMethodException,
                   JsonParseException,
                   IOException;
}
