/* **********************************************************
 * Copyright 2012, 2022 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonErrorResponse.java --
 *
 *      Class to represent a JSON RPC 2.0 error response.
 */

package com.vmware.vapi.internal.protocol.common.json;

public final class JsonErrorResponse extends JsonBaseResponse {
    private final JsonError error;

    /**
     * Constructor
     *
     * @param id Identifier to be used in the JSON-RPC 2.0 response
     * @param error JsonError object specifying the error details
     */
    public JsonErrorResponse(String id, JsonError error) {
        super(id);
        this.error = error;
    }

    public JsonError getError() {
        return error;
    }

    public boolean isError() {
        return true;
    }
}
