/* **********************************************************
 * Copyright 2012, 2019 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */

/*
 * JsonInvalidRequest.java --
 *
 *      Exception class to denote an invalid JSON request. This does not
 *      include JSON parse errors.
 */

package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.internal.util.Validate;

public final class JsonInvalidRequest extends Exception {
    /**
     * Generated
     */
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String message;

    /**
     * Constructor
     *
     * @param message Reason why JSON request is invalid
     * @param id ID of the JSON-RPC 2.0 message
     */
    public JsonInvalidRequest(String message, String id) {
        super(message);

        // TODO: it can be null if "id" field is not parsed yet
        //   Validate.notNull(id);
        Validate.notNull(message);

        this.message = message;
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public String getMsg() {
        return message;
    }
}
