/* **********************************************************
 * Copyright 2012 VMware, Inc. All rights reserved. -- VMware Confidential
 * *********************************************************
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.data.DataValue;

public final class JsonProgressResponse extends JsonBaseResponse {

    /**
     * We need this wrapper class so that the default bean serializer of the jackson
     * library creates a 'progress' node inside the 'result' JSON-RPC node.
     */
    public static class JsonProgress {
        private final DataValue progress;

        public JsonProgress(DataValue progress) {
            this.progress = progress;
        }

        public DataValue getProgress() {
            return progress;
        }
    }

    private final JsonProgress result;

    public JsonProgressResponse(String id, DataValue progress) {
        super(id);
        this.result = new JsonProgress(progress);
    }

    public JsonProgress getResult() {
        return result;
    }

    public DataValue retrieveProgress() {
        if (result != null) {
            return result.getProgress();
        } else {
            return null;
        }
    }
}
