/* **********************************************************
 * Copyright 2010-2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.protocol.server.rpc.http.impl;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vmware.vapi.protocol.server.rpc.http.LifecycleListener;
import com.vmware.vapi.protocol.server.rpc.http.LifecycleManager;

public class BasicLifecycleManager implements LifecycleManager {
   /** Logger */
   private Logger _logger =  LoggerFactory.getLogger(getClass());

   /** list of items to be shutdown upon server stop */
   private List<LifecycleListener> _lifecycleListeners;

   private boolean _stopped = false;

   @Override
   public synchronized void setLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
      if (_stopped) {
         throw new IllegalStateException(
               "Can not set the lifecycle listeners of stopped lifecycle manager!");
      }

      _lifecycleListeners = lifecycleListeners;
   }

   @Override
   public synchronized void addLifecycleListener(LifecycleListener lifecycleListener) {
      if (_stopped) {
         throw new IllegalStateException(
               "Can not add lifecycle listener to stopped lifecycle manager!");
      }

      if (_lifecycleListeners == null) {
         _lifecycleListeners = new ArrayList<LifecycleListener>();
      }

      _lifecycleListeners.add(lifecycleListener);
   }

   @Override
   public synchronized void shutdown() {
      if (_stopped) {
         return;
      }
      _stopped = true;

      if (_lifecycleListeners != null) {
         if (_logger.isInfoEnabled()) {
            _logger.info("Stopping lifecycle listeners.");
         }
         for (LifecycleListener shutdownable : _lifecycleListeners) {
            shutdownable.shutdown();
         }
      }
   }

   @Override
   public synchronized void shutdownNow() {
      if (_stopped) {
         return;
      }
      _stopped = true;

      if (_lifecycleListeners != null) {
         if (_logger.isInfoEnabled()) {
            _logger.info("Stopping lifecycle listeners immediately.");
         }
         for (LifecycleListener shutdownable : _lifecycleListeners) {
            shutdownable.shutdownNow();
         }
      }
   }
}