/* **********************************************************
 * Copyright 2011 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.internal.protocol.server.rpc.http.util;

import java.security.PublicKey;
import java.security.cert.X509Certificate;

import javax.servlet.http.HttpServletRequest;

import com.vmware.vapi.internal.protocol.server.rpc.http.common.impl.ThumbprintTrustManager;

/**
 * Common utilities to manage SSL connections
 */
public final class SslUtil {

   private SslUtil() {
      // prevent instantiation
   }

   /**
    * Adds javax.servlet.request.X509CertificateIsTrusted attribute to the
    * servlet request, using a trust manager to compute the value.
    * @param request the servlet request
    * @param trustManager the trust manager
    */
   public static void addCertTrustedAttribute(HttpServletRequest request,
                                              ThumbprintTrustManager trustManager) {
      X509Certificate[] certs =
         (X509Certificate[]) request
               .getAttribute("javax.servlet.request.X509Certificate");
      boolean isTrusted = false;
      if (null != certs && certs.length > 0 && trustManager != null) {
         isTrusted =
               trustManager
                     .isClientTrusted(certs, determineAuthType(certs[0]));
      }
      request.setAttribute("javax.servlet.request.X509CertificateIsTrusted",
            Boolean.valueOf(isTrusted));

   }

   private static String determineAuthType(X509Certificate cert) {
      PublicKey key = cert.getPublicKey();
      return key.getAlgorithm();
   }
}
