/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;

/**
 * Error in the introspection format.
 */
public final class IntrospectionException extends CoreException {

    private static final long serialVersionUID = 491103921260302858L;

    public IntrospectionException(Message message, Throwable cause) {
        super(message, cause);
    }

    public IntrospectionException(Message message) {
        this(message, null);
    }

    public IntrospectionException(String messageId, String... args) {
        super(messageId, args);
    }

}
