/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol;

import java.security.KeyStore;

public interface ProtocolConnectionFactory {

    ProtocolConnection getConnection(String type,
                                     String args,
                                     KeyStore trustStore);

    ProtocolConnection getInsecureConnection(String type,
                                             String args);

    /**
     * Creates an vAPI client that uses HTTP connection.
     *
     * @param uri  URI representing the server to connect. Should be of the form
     *             <tt>http(s)://[IP_address]:[port]/[Service_endpoint]</tt>. Can
     *             not be null.
     * @param clientConfig the client configuration. can be null.
     * @param httpConfig the transport configuration. can be null.
     * @return
     */
    ProtocolConnection getHttpConnection(String uri,
                                         ClientConfiguration clientConfig,
                                         HttpConfiguration httpConfig);
}
