/* **********************************************************
 * Copyright (c) 2018 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.client.http;

import java.util.List;
import java.util.Objects;

import com.vmware.vapi.core.HttpResponse;
import com.vmware.vapi.core.HttpResponseAccessor;

/**
 * Extractor which captures particular HTTP header from the raw REST response.
 *
 * <p>If header is repeated multiple times in the HTTP response, all the values
 * will be captured.
 */
public class HeaderExtractor implements HttpResponseAccessor {
    private final String headerName;
    private List<String> headerValue;

    /**
     * Constructor.
     *
     * @param headerName name of the header to be extracted; must not be
     * {@code null}.
     */
    public HeaderExtractor(String headerName) {
        this.headerName = Objects.requireNonNull(headerName) ;
    }

    @Override
    public void access(HttpResponse response) {
        headerValue = response.getHeader(headerName);
    }

    /**
     * Returns the captured HTTP header values.
     *
     * @return list of values for all occurrences of the specified header
     */
    public List<String> getHeaderValues() {
        return this.headerValue;
    }
}
