/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.common;

import com.vmware.vapi.internal.protocol.common.json.JsonMsgDeserializer2;
import com.vmware.vapi.internal.protocol.common.json.JsonMsgSerializer2;
import com.vmware.vapi.protocol.common.json.JsonRpcDeserializer;
import com.vmware.vapi.protocol.common.json.JsonRpcSerializer;

/**
 * Static factories for (de)serializers.
 */
public class Serializers {

    /**
     * Creates a JSON-RPC serializer instance.
     *
     * <p>The instances is thread-safe.
     *
     * @return new JSON-RPC serializer
     */
    public static JsonRpcSerializer newJsonRpcSerializer() {
        return new JsonMsgSerializer2();
    }

    /**
     * Creates a JSON-RPC deserializer instances.
     *
     * <p>The instances is thread-safe.
     *
     * @return new JSON-RPC deserializer.
     */
    public static JsonRpcDeserializer newJsonRpcDeserializer() {
        return new JsonMsgDeserializer2();
    }
}
