/* **********************************************************
 * Copyright (c) 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.common.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.data.DataValue;

/**
 * JSON-RPC deserializer for {@code DataValue}s.
 *
 * @see JsonRpcSerializer
 */
public interface JsonRpcDeserializer {

    /**
     * Deserializes a JSON string as {@code DataValue}.
     *
     * @param jsonString to be deserialized
     * @return deserialized {@code DataValue}
     * @throws CoreException if the provided {@code jsonString} cannot be
     *         deserialized
     */
    public DataValue deserializeDataValue(String jsonString);
}
