/* **********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol.server.rpc.http;

/**
 * Interface that provide common mechanism for life cycle management of tasks
 * and threads.
 */
public interface LifecycleListener {
   /**
    * Shutdown the task. The call to this method should block until the shutdown
    * is complete.<br><br>
    *
    * Shutting down a {@link LifecycleListener} that is already shutdown or in
    * the process of shutting down should have no effect.
    */
   public void shutdown();

   /**
    * Initiate ungraceful shutdown. The method call should return immediately
    * without blocking until the shutdown completes.<br><br>
    *
    * Shutting down a {@link LifecycleListener} that is already shutdown or in
    * the process of shutting down should have no effect.
    */
   public void shutdownNow();
}