/* **********************************************************
 * Copyright 2013 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/
package com.vmware.vapi.protocol.server.rpc.http;

import com.vmware.vapi.protocol.server.rpc.RequestReceiver;

/**
 * Resolution policy which maps a media type (MIME type) to a content handler.
 */
public interface MediaTypeResolver {

    /**
     * Returns a handler which is meant to process content of the specified
     * media type.
     *
     * @param mediaType media/MIME type; for example application/json; must not
     *                  be <code>null</code>
     * @return content handler; <code>null</code> if there is no matching
     *         handler
     */
    RequestReceiver getHandler(String mediaType);
}
