/* **********************************************************
 * Copyright 2010 VMware, Inc.  All rights reserved.
 *      -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.protocol.server.rpc.http.impl;

import java.io.File;
import java.io.IOException;
import java.util.Map;

import javax.servlet.Servlet;

import org.springframework.core.io.Resource;

import com.vmware.vapi.protocol.server.rpc.http.Service;
import com.vmware.vapi.protocol.server.rpc.http.StaticContentService;

/**
 * Instances of this class can be configured in the usual way
 * except that it is not allowed to {@link Service#setServlet}
 * or {@link Service#setInitParameters}.
 */
public class StaticContentServiceImpl extends ServiceImpl
                              implements StaticContentService {

   private Resource _contentBase;
   private String _contentBasePath;
   private boolean _dirListing;

   public StaticContentServiceImpl() {}

   @Override
   public void setInitParameters(Map<String, String> params) {
      throw new UnsupportedOperationException(
            "Setting init parameters is not allowed");
   }

   @Override
   public void setServlet(Servlet servlet) {
      throw new UnsupportedOperationException(
            "Setting servlet instance is not allowed");
   }

   @Override
   public void setContentBase(Resource contentBase) throws IOException {
      File baseFile = contentBase.getFile();
      if (!baseFile.isDirectory()) {
         throw new IOException("contentBase should denote a directory");
      }

      _contentBasePath = baseFile.getAbsolutePath();
      _contentBase = contentBase;
   }

   @Override
   public Resource getContentBase() {
      return _contentBase;
   }

   @Override
   public String getContentBasePath() {
      return _contentBasePath;
   }

   @Override
   public void setDirListing(boolean dirListing) {
      _dirListing = dirListing;
   }

   @Override
   public boolean getDirListing() {
      return _dirListing;
   }
}
