/* **********************************************************
 * Copyright 2013 VMware, Inc. All rights reserved.
 *      -- VMware Confidential
 * *********************************************************
 */

/*
 * SyncApiIntrospection.java --
 *
 *      Synchronous interface for API Introspection.
 */

package com.vmware.vapi.provider.introspection;

import java.util.Set;

import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.ProviderDefinition;

/**
 * Synchronous interface for API Introspection.
 */
public interface SyncApiIntrospection {

    /**
     * Returns the definition for this API provider.
     *
     * @param ctx       execution context for the invocation
     * @return definition for this provider
     */
    public ProviderDefinition getDefinition(ExecutionContext ctx);

    /**
     * Returns the set of interface identifiers supported by this provider.
     *
     * @param ctx       execution context for the invocation
     * @return set of identifiers
     */
    public Set<InterfaceIdentifier> getInterfaceIdentifiers(
            ExecutionContext ctx);

    /**
     * Returns interface definition for a given interface identifier.
     *
     * @param ctx       execution context for the invocation
     * @param ifaceId   interface identifier
     * @return          interface definition for the given interface identifier
     */
    public InterfaceDefinition getInterface(ExecutionContext ctx,
            InterfaceIdentifier ifaceId);

    /**
     * Returns method definitions for a given method identifier. or
     * <code>null</code> if no such method is available
     *
     * @param ctx       execution context for the invocation
     * @param methodId  method identifier
     * @return <code>MethodDefinition</code> instance or <code>null</code>
     *         is not found for the specified identifier
     */
    public MethodDefinition getMethod(ExecutionContext ctx,
            MethodIdentifier methodId);
}
