/* **********************************************************
 * Copyright (c) 2014, 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

package com.vmware.vapi.std;

/**
 * Factory for built-in vAPI data objects.
 */
public class BuiltInDataFactory {
    /**
     * Name for map entry "artificial" {@code StructValue} instances. These
     * map entry instances are hold in a {@code ListValue} to represent the
     * whole map.
     */
    public static final String MAP_ENTRY_STRUCT_NAME = "map-entry";

    /**
     * Name for a {@code StructValue} representing a map with with
     * {@code String} typed keys.
     */
    public static final String MAP_STRUCT_NAME = "map-struct";

    /**
     * Name for operation input "artificial" {@code StructValue} instances. The
     * fields of such instances are the operation parameters' names and values.
     */
    public static final String OPERATION_INPUT_STRUCT_NAME = "operation-input";
}