/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std;

/**
 * The {@code DynamicID} class represents an identifier for a resource of an
 * arbitrary type.
 */
public final class DynamicID implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    private java.lang.String type;

    private java.lang.String id;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public DynamicID(java.lang.String type, java.lang.String id) {
        this();
        this.type = type;
        this.id = id;
    }

    /**
     * Default constructor.
     */
    public DynamicID() {
    }

    protected DynamicID(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this.__dynamicStructureFields = __dynamicStructureFields;
    }


    /**
     * The type of resource being identified (for example {@code com.acme.Person}).
     *
     * <p> Interfaces that contain methods for creating and deleting resources
     * typically contain a constant field specifying the resource type for the
     * resources being created and deleted. The API metamodel metadata interfaces
     * include a interface that allows retrieving all the known resource types.</p>
     *
     * @return The current value of the property.
     */
    public java.lang.String getType() {
        return this.type;
    }

    /**
     * The type of resource being identified (for example {@code com.acme.Person}).
     *
     * <p> Interfaces that contain methods for creating and deleting resources
     * typically contain a constant field specifying the resource type for the
     * resources being created and deleted. The API metamodel metadata interfaces
     * include a interface that allows retrieving all the known resource types.</p>
     *
     * @param type New value for the property.
     */
    public void setType(java.lang.String type) {
        this.type = type;
    }

    /**
     * The identifier for a resource whose type is specified by {@link
     * com.vmware.vapi.std.DynamicID#getType}.
     *
     * @return The current value of the property.
     * When clients pass a value of this class as a parameter, the property {@code
     * getType()} must contain the actual resource type. When methods return a value of
     * this class as a return value, the property {@code getType()} will contain the
     * actual resource type.
     */
    public java.lang.String getId() {
        return this.id;
    }

    /**
     * The identifier for a resource whose type is specified by {@link
     * com.vmware.vapi.std.DynamicID#getType}.
     *
     * @param id New value for the property.
     * When clients pass a value of this class as a parameter, the property {@code
     * getType()} must contain the actual resource type. When methods return a value of
     * this class as a return value, the property {@code getType()} will contain the
     * actual resource type.
     */
    public void setId(java.lang.String id) {
        this.id = id;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.StructType _getType() {
        return com.vmware.vapi.std.StructDefinitions.dynamicID;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.type, this._getType().getField("type")));
        structValue.setField("id",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.id, this._getType().getField("id")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String toString() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.StructType} instance representing the static bindings
     * type for this <code>Structure</code>.
     */
    public static com.vmware.vapi.bindings.type.StructType _getClassType() {
        return com.vmware.vapi.std.StructDefinitions.dynamicID;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.StructDefinitions.dynamicID.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.StructValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static DynamicID _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new DynamicID(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static DynamicID _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new DynamicID(structValue);
    }

    /**
     * Builder class for {@link DynamicID}.
     */
    public static final class Builder {
        private java.lang.String type;
        private java.lang.String id;

        /**
         * Constructor with parameters for the required properties of
         * {@link DynamicID}.
         */
        public Builder(java.lang.String type, java.lang.String id) {
            this.type = type;
            this.id = id;
        }

        public DynamicID build() {
            DynamicID result = new DynamicID();
            result.setType(this.type);
            result.setId(this.id);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.StructType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.List<com.vmware.vapi.internal.data.ConstraintValidator> validators = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("type", new com.vmware.vapi.bindings.type.StringType());
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("type",
                                                                                "type",
                                                                                "getType",
                                                                                "setType");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("id", new com.vmware.vapi.bindings.type.IdType(null, "type"));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("id",
                                                                                "id",
                                                                                "getId",
                                                                                "setId");
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.StructType("com.vmware.vapi.std.dynamic_ID",
                                                            fields,
                                                            com.vmware.vapi.std.DynamicID.class,
                                                            validators,
                                                            false,
                                                            null,
                                                            fieldNameDetails,
                                                            null,
                                                            null);
    }
}

