/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.errors.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std.errors;

/**
 * The {@code Error} exception describes theproperties common to all standard
 * exceptions. 
 * <p> This exception serves two purposes: </p><ol> <li>It is the
 * exception that clients in many programming languages can catch to handle all
 * standard exceptions. Typically those clients will display one or more of the
 * localizable messages from {@link com.vmware.vapi.std.errors.Error#getMessages}
 * to a human. </li> <li>It is the exception that methods can report when they need
 * to report some exception, but the exception doesn't fit into any other standard
 * exception, and in fact the only reasonable way for a client to react to the
 * exception is to display the message(s) to a human. </li> </ol>
 */
public class Error extends com.vmware.vapi.bindings.ApiError implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * Enumeration of all standard errors. Used as discriminator in protocols that have
     * no standard means for transporting the error type, e.g. REST.
     *
     * <p> See {@link com.vmware.vapi.bindings.ApiEnumeration enumerated types description}.
     */
    public static final
    class Type extends com.vmware.vapi.bindings.ApiEnumeration<Type> {

        /**
         * Native Java {@code enum} representing this enumeration class.
         * Ordinals have no semantic meaning (your code should not rely on them).
         * <p>
         * See {@link #getEnumValue}.
         */
        public enum Values {
            /**
             * Represents {@link Type#ERROR}.
             */
            ERROR,

            /**
             * Represents {@link Type#ALREADY_EXISTS}.
             */
            ALREADY_EXISTS,

            /**
             * Represents {@link Type#ALREADY_IN_DESIRED_STATE}.
             */
            ALREADY_IN_DESIRED_STATE,

            /**
             * Represents {@link Type#CANCELED}.
             */
            CANCELED,

            /**
             * Represents {@link Type#CONCURRENT_CHANGE}.
             */
            CONCURRENT_CHANGE,

            /**
             * Represents {@link Type#FEATURE_IN_USE}.
             */
            FEATURE_IN_USE,

            /**
             * Represents {@link Type#INTERNAL_SERVER_ERROR}.
             */
            INTERNAL_SERVER_ERROR,

            /**
             * Represents {@link Type#INVALID_ARGUMENT}.
             */
            INVALID_ARGUMENT,

            /**
             * Represents {@link Type#INVALID_ELEMENT_CONFIGURATION}.
             */
            INVALID_ELEMENT_CONFIGURATION,

            /**
             * Represents {@link Type#INVALID_ELEMENT_TYPE}.
             */
            INVALID_ELEMENT_TYPE,

            /**
             * Represents {@link Type#INVALID_REQUEST}.
             */
            INVALID_REQUEST,

            /**
             * Represents {@link Type#NOT_ALLOWED_IN_CURRENT_STATE}.
             */
            NOT_ALLOWED_IN_CURRENT_STATE,

            /**
             * Represents {@link Type#NOT_FOUND}.
             */
            NOT_FOUND,

            /**
             * Represents {@link Type#OPERATION_NOT_FOUND}.
             */
            OPERATION_NOT_FOUND,

            /**
             * Represents {@link Type#RESOURCE_BUSY}.
             */
            RESOURCE_BUSY,

            /**
             * Represents {@link Type#RESOURCE_IN_USE}.
             */
            RESOURCE_IN_USE,

            /**
             * Represents {@link Type#RESOURCE_INACCESSIBLE}.
             */
            RESOURCE_INACCESSIBLE,

            /**
             * Represents {@link Type#SERVICE_UNAVAILABLE}.
             */
            SERVICE_UNAVAILABLE,

            /**
             * Represents {@link Type#TIMED_OUT}.
             */
            TIMED_OUT,

            /**
             * Represents {@link Type#UNABLE_TO_ALLOCATE_RESOURCE}.
             */
            UNABLE_TO_ALLOCATE_RESOURCE,

            /**
             * Represents {@link Type#UNAUTHENTICATED}.
             */
            UNAUTHENTICATED,

            /**
             * Represents {@link Type#UNAUTHORIZED}.
             */
            UNAUTHORIZED,

            /**
             * Represents {@link Type#UNEXPECTED_INPUT}.
             */
            UNEXPECTED_INPUT,

            /**
             * Represents {@link Type#UNSUPPORTED}.
             */
            UNSUPPORTED,

            /**
             * Represents {@link Type#UNVERIFIED_PEER}.
             */
            UNVERIFIED_PEER,

            /**
             * Special {@code enum} constant which is used to represent constants
             * that do not exist in this enumeration binding. For example if a
             * client receives an enumeration constant that only exists in the
             * newer version of the API of the server, the client source code will
             * see it represented by {@code _UNKNOWN} constant, because its version
             * of the native Java {@code enum} lacks the new constant.
             */
            _UNKNOWN,
        }


        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.Error} type.
         */
        public static final Type ERROR = new Type("ERROR");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.AlreadyExists} type.
         */
        public static final Type ALREADY_EXISTS = new Type("ALREADY_EXISTS");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.AlreadyInDesiredState}
         * type.
         */
        public static final Type ALREADY_IN_DESIRED_STATE = new Type("ALREADY_IN_DESIRED_STATE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.Canceled} type.
         */
        public static final Type CANCELED = new Type("CANCELED");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.ConcurrentChange} type.
         */
        public static final Type CONCURRENT_CHANGE = new Type("CONCURRENT_CHANGE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.FeatureInUse} type.
         */
        public static final Type FEATURE_IN_USE = new Type("FEATURE_IN_USE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.InternalServerError}
         * type.
         */
        public static final Type INTERNAL_SERVER_ERROR = new Type("INTERNAL_SERVER_ERROR");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.InvalidArgument} type.
         */
        public static final Type INVALID_ARGUMENT = new Type("INVALID_ARGUMENT");

        /**
         * Discriminator for the {@link
         * com.vmware.vapi.std.errors.InvalidElementConfiguration} type.
         */
        public static final Type INVALID_ELEMENT_CONFIGURATION = new Type("INVALID_ELEMENT_CONFIGURATION");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.InvalidElementType}
         * type.
         */
        public static final Type INVALID_ELEMENT_TYPE = new Type("INVALID_ELEMENT_TYPE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.InvalidRequest} type.
         */
        public static final Type INVALID_REQUEST = new Type("INVALID_REQUEST");

        /**
         * Discriminator for the {@link
         * com.vmware.vapi.std.errors.NotAllowedInCurrentState} type.
         */
        public static final Type NOT_ALLOWED_IN_CURRENT_STATE = new Type("NOT_ALLOWED_IN_CURRENT_STATE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.NotFound} type.
         */
        public static final Type NOT_FOUND = new Type("NOT_FOUND");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.OperationNotFound} type.
         */
        public static final Type OPERATION_NOT_FOUND = new Type("OPERATION_NOT_FOUND");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.ResourceBusy} type.
         */
        public static final Type RESOURCE_BUSY = new Type("RESOURCE_BUSY");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.ResourceInUse} type.
         */
        public static final Type RESOURCE_IN_USE = new Type("RESOURCE_IN_USE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.ResourceInaccessible}
         * type.
         */
        public static final Type RESOURCE_INACCESSIBLE = new Type("RESOURCE_INACCESSIBLE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.ServiceUnavailable}
         * type.
         */
        public static final Type SERVICE_UNAVAILABLE = new Type("SERVICE_UNAVAILABLE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.TimedOut} type.
         */
        public static final Type TIMED_OUT = new Type("TIMED_OUT");

        /**
         * Discriminator for the {@link
         * com.vmware.vapi.std.errors.UnableToAllocateResource} type.
         */
        public static final Type UNABLE_TO_ALLOCATE_RESOURCE = new Type("UNABLE_TO_ALLOCATE_RESOURCE");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.Unauthenticated} type.
         */
        public static final Type UNAUTHENTICATED = new Type("UNAUTHENTICATED");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.Unauthorized} type.
         */
        public static final Type UNAUTHORIZED = new Type("UNAUTHORIZED");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.UnexpectedInput} type.
         */
        public static final Type UNEXPECTED_INPUT = new Type("UNEXPECTED_INPUT");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.Unsupported} type.
         */
        public static final Type UNSUPPORTED = new Type("UNSUPPORTED");

        /**
         * Discriminator for the {@link com.vmware.vapi.std.errors.UnverifiedPeer} type.
         */
        public static final Type UNVERIFIED_PEER = new Type("UNVERIFIED_PEER");

        private static final long serialVersionUID = 1L;

        private static final Type[] $VALUES = new Type[] {ERROR, ALREADY_EXISTS, ALREADY_IN_DESIRED_STATE, CANCELED, CONCURRENT_CHANGE, FEATURE_IN_USE, INTERNAL_SERVER_ERROR, INVALID_ARGUMENT, INVALID_ELEMENT_CONFIGURATION, INVALID_ELEMENT_TYPE, INVALID_REQUEST, NOT_ALLOWED_IN_CURRENT_STATE, NOT_FOUND, OPERATION_NOT_FOUND, RESOURCE_BUSY, RESOURCE_IN_USE, RESOURCE_INACCESSIBLE, SERVICE_UNAVAILABLE, TIMED_OUT, UNABLE_TO_ALLOCATE_RESOURCE, UNAUTHENTICATED, UNAUTHORIZED, UNEXPECTED_INPUT, UNSUPPORTED, UNVERIFIED_PEER};

        private static final java.util.Map<java.lang.String, Type> $NAME_TO_VALUE_MAP = com.vmware.vapi.bindings.ApiEnumeration.buildNameMap($VALUES);

        private Type() {
            super(Values._UNKNOWN.name());
        }

        private Type(java.lang.String name) {
            super(name);
        }

        /**
         * Retrieve all enumeration constants <b>pre-defined</b> by this enumeration class.
         * <p>
         * Additional instances might exist at runtime, for example to represent a
         * new constant added to this enumeration class in subsequent version of the
         * API. Such new constant is represented as instance of {@link Type}
         * but is not <b>pre-defined</b>.
         *
         * @return Array of all <b>pre-defined</b> enumeration constants. Never {@code null}.
         */
        public static Type[] values() {
            return $VALUES.clone();
        }

        /**
         * Returns the enumeration constant for the specified name.
         * <p>
         * If the name matches exactly the identifier used to declare an enumeration
         * constant from this enumeration class, the constant in question will be returned.
         * <p>
         * Otherwise, a new instance of {@link Type} will be returned for the
         * specified name, which will not be one of the <b>pre-defined</b> constant
         * instances. Such new instance maps to the {@link Values#_UNKNOWN}
         * {@code enum} constant from the native Java {@code enum}.
         *
         * @param name The name of the constant to return. Must not be {@code null}.
         * @return Enumeration constant for the specified name. Never {@code null}.
         */
        public static Type valueOf(java.lang.String name) {
            if (name == null) {
                throw new java.lang.NullPointerException();
            }
            Type predefined = $NAME_TO_VALUE_MAP.get(name);
            if (predefined != null) {
                return predefined;
            }
            return new Type(name);
        }

        /**
         * Checks if this enumeration constant is unknown. Unknown is a constant
         * that is not one of the <b>pre-defined</b> ones for this enumeration class.
         * Also see {@link #valueOf} and {@link #values}.
         *
         * @return {@code true} if this constant is unknown, and {@code false} otherwise.
         */
        public boolean isUnknown() {
            return getEnumValue() == Values._UNKNOWN;
        }

        /**
         * Returns a native Java {@code enum} constant representing this enumeration
         * constant. The result is useful for usual handling of Java {@code enum},
         * for example it can be used in {@code switch} statements.
         * <p>
         * If this enumeration constant is unknown, then {@link Values#_UNKNOWN}
         * {@code enum} constant is returned.
         * <p>
         * The native Java {@code enum} is {@link Values}.
         *
         * @return The Java {@code enum} constant. Never {@code null}.
         */
        public Values getEnumValue() {
            try {
                return Values.valueOf(name());
            } catch (IllegalArgumentException ex) {
                return Values._UNKNOWN;
            }
        }

        private java.lang.Object readResolve() {
            return valueOf(name());
        }
    }


    private java.util.List<com.vmware.vapi.std.LocalizableMessage> messages;

    private com.vmware.vapi.bindings.Structure data;

    private final com.vmware.vapi.std.errors.Error.Type errorType;

    protected com.vmware.vapi.data.StructValue __dynamicStructureFields;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public Error(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages, com.vmware.vapi.bindings.Structure data) {
        this();
        this.messages = messages;
        this.data = data;
    }

    /**
     * Default constructor.
     */
    public Error() {
        this((com.vmware.vapi.data.StructValue)null);
    }

    protected Error(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this(__dynamicStructureFields, com.vmware.vapi.std.errors.Error.Type.ERROR);
    }

    protected Error(com.vmware.vapi.data.StructValue __dynamicStructureFields, com.vmware.vapi.std.errors.Error.Type errorType) {
        this.__dynamicStructureFields = __dynamicStructureFields;
        setMessages(java.util.Collections.<com.vmware.vapi.std.LocalizableMessage>emptyList());
        this.errorType = errorType;
    }

    /**
     * Stack of one or more localizable messages for human exception consumers. 
     * <p>
     * The message at the top of the stack (first in the list) describes the exception
     * from the perspective of the method the client invoked. </p>
     * <p> Each subsequent
     * message in the stack describes the "cause" of the prior message.</p>
     *
     * @return The current value of the property.
     */
    public java.util.List<com.vmware.vapi.std.LocalizableMessage> getMessages() {
        return this.messages;
    }

    /**
     * Stack of one or more localizable messages for human exception consumers. 
     * <p>
     * The message at the top of the stack (first in the list) describes the exception
     * from the perspective of the method the client invoked. </p>
     * <p> Each subsequent
     * message in the stack describes the "cause" of the prior message.</p>
     *
     * @param messages New value for the property.
     */
    public void setMessages(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages) {
        this.messages = messages;
    }

    /**
     * Data to facilitate clients responding to the method reporting a standard
     * exception to indicating that it was unable to complete successfully. 
     * <p>
     * Methods may provide data that clients can use when responding to exceptions.
     * Since the data that clients need may be specific to the context of the method
     * reporting the exception, different methods that report the same exception may
     * provide different data in the exception. The documentation for each each method
     * will describe what, if any, data it provides for each exception it reports.
     * </p>
     * <p> The {@link com.vmware.vapi.std.errors.ArgumentLocations}, {@link
     * com.vmware.vapi.std.errors.FileLocations}, and {@link
     * com.vmware.vapi.std.errors.TransientIndication} classes are intended as possible
     * values for this property. {@link com.vmware.vapi.std.DynamicID} may also be
     * useful as a value for this property (although that is not its primary purpose).
     * Some interfaces may provide their own specific classes for use as the value of
     * this property when reporting exceptions from their methods.</p>
     *
     * Some methods will not set this property when reporting exceptions.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.bindings.Structure getData() {
        return this.data;
    }

    /**
     * Data to facilitate clients responding to the method reporting a standard
     * exception to indicating that it was unable to complete successfully. 
     * <p>
     * Methods may provide data that clients can use when responding to exceptions.
     * Since the data that clients need may be specific to the context of the method
     * reporting the exception, different methods that report the same exception may
     * provide different data in the exception. The documentation for each each method
     * will describe what, if any, data it provides for each exception it reports.
     * </p>
     * <p> The {@link com.vmware.vapi.std.errors.ArgumentLocations}, {@link
     * com.vmware.vapi.std.errors.FileLocations}, and {@link
     * com.vmware.vapi.std.errors.TransientIndication} classes are intended as possible
     * values for this property. {@link com.vmware.vapi.std.DynamicID} may also be
     * useful as a value for this property (although that is not its primary purpose).
     * Some interfaces may provide their own specific classes for use as the value of
     * this property when reporting exceptions from their methods.</p>
     *
     * Some methods will not set this property when reporting exceptions.
     *
     * @param data New value for the property.
     */
    public void setData(com.vmware.vapi.bindings.Structure data) {
        this.data = data;
    }

    /**
     * Discriminator field to help API consumers identify the structure type.
     * The value of this property is automatically populated.
     *
     * Can be {@code null} for compatibility with preceding implementations.
     *
     * @return The current value of the property.
     */
    public com.vmware.vapi.std.errors.Error.Type getErrorType() {
        return this.errorType;
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.ErrorType _getType() {
        return com.vmware.vapi.std.errors.StructDefinitions.error;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        structValue.setField("messages",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.messages, this._getType().getField("messages")));
        structValue.setField("data",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.data, this._getType().getField("data")));
        structValue.setField("error_type",
                com.vmware.vapi.internal.bindings.BindingsUtil.toDataValue(
                        this.errorType, this._getType().getField("error_type")));
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String getMessage() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.ErrorType} instance representing the static bindings
     * type for this <code>Error</code>.
     */
    public static com.vmware.vapi.bindings.type.ErrorType _getClassType() {
        return com.vmware.vapi.std.errors.StructDefinitions.error;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.errors.StructDefinitions.error.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.ErrorValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static Error _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new Error(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static Error _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new Error(structValue);
    }

    /**
     * Builder class for {@link Error}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.vapi.std.LocalizableMessage> messages;
        private com.vmware.vapi.bindings.Structure data;

        /**
         * Constructor with parameters for the required properties of
         * {@link Error}.
         */
        public Builder(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages) {
            this.messages = messages;
        }

        /**
         * Data to facilitate clients responding to the method reporting a standard
         * exception to indicating that it was unable to complete successfully. 
         * <p>
         * Methods may provide data that clients can use when responding to exceptions.
         * Since the data that clients need may be specific to the context of the method
         * reporting the exception, different methods that report the same exception may
         * provide different data in the exception. The documentation for each each method
         * will describe what, if any, data it provides for each exception it reports.
         * </p>
         * <p> The {@link com.vmware.vapi.std.errors.ArgumentLocations}, {@link
         * com.vmware.vapi.std.errors.FileLocations}, and {@link
         * com.vmware.vapi.std.errors.TransientIndication} classes are intended as possible
         * values for this property. {@link com.vmware.vapi.std.DynamicID} may also be
         * useful as a value for this property (although that is not its primary purpose).
         * Some interfaces may provide their own specific classes for use as the value of
         * this property when reporting exceptions from their methods.</p>
         *
         * Some methods will not set this property when reporting exceptions.
         *
         * @param data New value for the property.
         */
        public Builder setData(com.vmware.vapi.bindings.Structure data) {
            this.data = data;
            return this;
        }

        public Error build() {
            Error result = new Error();
            result.setMessages(this.messages);
            result.setData(this.data);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.ErrorType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("messages", new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.StructDefinitions.localizableMessage; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("messages",
                                                                                "messages",
                                                                                "getMessages",
                                                                                "setMessages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data",
                                                                                "data",
                                                                                "getData",
                                                                                "setData");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.EnumType("com.vmware.vapi.std.errors.error.type", com.vmware.vapi.std.errors.Error.Type.class)));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_type",
                                                                                "errorType",
                                                                                "getErrorType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.ErrorType("com.vmware.vapi.std.errors.error",
                                                           fields,
                                                           com.vmware.vapi.std.errors.Error.class,
                                                           fieldNameDetails);
    }
}

