/*
 * Copyright 2023 VMware, Inc.  All rights reserved.
 */

/*
 * AUTO GENERATED FILE -- DO NOT MODIFY!
 *
 * Skeleton file for package: com.vmware.vapi.std.errors.
 * Represents a binding of a top level structure.
 */

package com.vmware.vapi.std.errors;

/**
 * The {@code InvalidArgument} exception indicates that the values received for one
 * or more parameters are not acceptable. 
 * <p> This exception is reported by the
 * API infrastructure, so it could occur in response to the invocation of any
 * method. It may also be reported as the result of method-specific validation.
 * </p>
 * <p> Examples: </p><ul> <li>A parameter has a value that is not of the
 * expected type. </li> <li>A parameter has a value that is not in the required
 * range. </li> <li>A parameter has a value that is not one of the specifically
 * allowed strings. </li> <li>One property of a class is the tag for a tagged
 * union, and has a specific value but another property of the class that is
 * required to be specified when the tag has that value is not specified, or
 * another property of the class that is required to be unspecified when the tag
 * has that value is specified. </li> </ul> 
 * <p> Counterexamples: </p><ul>
 * <li>Trying to create a new tag in tag category when a tag with the specified
 * name already exists the tag category. The {@link
 * com.vmware.vapi.std.errors.AlreadyExists} exception would be used instead. </li>
 * <li>Invoke the method to retrieve information about a virtual machine, passing
 * an id that does not identify an existing virtual machine. The {@link
 * com.vmware.vapi.std.errors.NotFound} exception would be used instead. </li>
 * <li>Attempt to put a virtual machine into a folder that can only contain hosts.
 * The {@link com.vmware.vapi.std.errors.InvalidElementType} exception would be
 * used instead. </li> <li>Attempt to attach a SCSI virtual disk to an IDE port.
 * The {@link com.vmware.vapi.std.errors.InvalidElementType} exception would be
 * used instead. </li> </ul>
 */
public class InvalidArgument extends com.vmware.vapi.std.errors.Error implements java.io.Serializable, com.vmware.vapi.bindings.StaticStructure {

    private static final long serialVersionUID = 1L;

    /**
     * This constructor is provided for backwards compatibility purposes only. Please use the Builder class instead.
     */
    public InvalidArgument(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages, com.vmware.vapi.bindings.Structure data) {
        this();
        this.setMessages(messages);
        this.setData(data);
    }

    /**
     * Default constructor.
     */
    public InvalidArgument() {
        this((com.vmware.vapi.data.StructValue)null);
    }

    protected InvalidArgument(com.vmware.vapi.data.StructValue __dynamicStructureFields) {
        this(__dynamicStructureFields, com.vmware.vapi.std.errors.Error.Type.INVALID_ARGUMENT);
    }

    protected InvalidArgument(com.vmware.vapi.data.StructValue __dynamicStructureFields, com.vmware.vapi.std.errors.Error.Type errorType) {
        super(__dynamicStructureFields, errorType);
    }

   @java.lang.Override
    public com.vmware.vapi.bindings.type.ErrorType _getType() {
        return com.vmware.vapi.std.errors.StructDefinitions.invalidArgument;
    }

    @java.lang.Override
    public com.vmware.vapi.data.StructValue _getDataValue() {
        com.vmware.vapi.data.StructValue dataValue;
        if (__dynamicStructureFields != null) {
            dataValue = __dynamicStructureFields.copy();
        } else {
            dataValue = createEmptyStructValue();
        }
        this._updateDataValue(dataValue);
        return dataValue;
    }

    protected void _updateDataValue(com.vmware.vapi.data.StructValue structValue) {
        super._updateDataValue(structValue);
    }

    @java.lang.Override
    public void _validate() {
        this._getType().validate(this._getDataValue());
    }

    @java.lang.Override
    public boolean equals(java.lang.Object obj) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.areEqual(this, obj);
    }

    @java.lang.Override
    public int hashCode() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.computeHashCode(this);
    }

    @java.lang.Override
    public java.lang.String getMessage() {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertToString(this, __dynamicStructureFields);
    }

    @java.lang.Override
    public boolean _hasTypeNameOf(Class<? extends com.vmware.vapi.bindings.Structure> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.hasTypeNameOf(_getDataValue(), clazz);
    }

    @java.lang.Override
    public <T extends com.vmware.vapi.bindings.Structure> T _convertTo(Class<T> clazz) {
        return com.vmware.vapi.internal.bindings.BindingsUtil.convertTo(this, clazz);
    }

    @java.lang.Override
    public void _setDynamicField(String fieldName, com.vmware.vapi.data.DataValue fieldValue) {
        if (_getType().getFieldNames().contains(fieldName)) {
             throw new com.vmware.vapi.client.exception.BindingsException("The structure contains static field with name " + fieldName);
        }
        if(__dynamicStructureFields == null) {
            __dynamicStructureFields = createEmptyStructValue();
        }
        __dynamicStructureFields.setField(fieldName, fieldValue);
    }

    @java.lang.Override
    public com.vmware.vapi.data.DataValue _getDynamicField(String fieldName) {
        if (__dynamicStructureFields == null || !__dynamicStructureFields.getFieldNames().contains(fieldName)) {
            throw new com.vmware.vapi.client.exception.BindingsException("The structure doesn't contain dynamic field with name " + fieldName);
        }
        return __dynamicStructureFields.getField(fieldName);
    }

    @java.lang.Override
    public java.util.Set<java.lang.String> _getDynamicFieldNames() {
        if (__dynamicStructureFields == null) {
            return java.util.Collections.<java.lang.String>emptySet();
        }
        return __dynamicStructureFields.getFieldNames();
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.
     *
     * @return {@link com.vmware.vapi.bindings.type.ErrorType} instance representing the static bindings
     * type for this <code>Error</code>.
     */
    public static com.vmware.vapi.bindings.type.ErrorType _getClassType() {
        return com.vmware.vapi.std.errors.StructDefinitions.invalidArgument;
    }

    @java.lang.Override
    public java.lang.String _getCanonicalName() {
        if (__dynamicStructureFields != null) {
            return __dynamicStructureFields.getName();
        }
        return com.vmware.vapi.std.errors.StructDefinitions.invalidArgument.getName();
    }

    /**
     * Returns the canonical type name. See {@link #_getCanonicalName()}.
     *
     * @return canonical type name
     */
    public static java.lang.String _getCanonicalTypeName() {
        return _getClassType().getName();
    }

    private static com.vmware.vapi.data.StructValue createEmptyStructValue() {
        return new com.vmware.vapi.data.ErrorValue(_getCanonicalTypeName());
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     *
     * Returns new instance of this binding class and injects the provided data value.<br>
     *
     * <b>WARNING:</b> The returned object is not fully initialized.<br>
     *
     * @param structValue the source of the data contained in the binding object. Could
     *                    contain more data than fields of this class can describe i.e.
     *                    newer version of the binding object. Could be null.
     * @return the static bindings <code>StructType</code>
     */
    public static InvalidArgument _newInstance(com.vmware.vapi.data.StructValue structValue) {
        return new InvalidArgument(structValue);
    }

    /**
     * <b>WARNING:</b> Internal method, subject to change in future versions.<br>
     * Serves as a versioning mechanism.
     */
    public static InvalidArgument _newInstance2(com.vmware.vapi.data.StructValue structValue) {
        return new InvalidArgument(structValue);
    }

    /**
     * Builder class for {@link InvalidArgument}.
     */
    public static final class Builder {
        private java.util.List<com.vmware.vapi.std.LocalizableMessage> messages;
        private com.vmware.vapi.bindings.Structure data;

        /**
         * Constructor with parameters for the required properties of
         * {@link InvalidArgument}.
         */
        public Builder(java.util.List<com.vmware.vapi.std.LocalizableMessage> messages) {
            this.messages = messages;
        }

        /**
         * Data to facilitate clients responding to the method reporting a standard
         * exception to indicating that it was unable to complete successfully. 
         * <p>
         * Methods may provide data that clients can use when responding to exceptions.
         * Since the data that clients need may be specific to the context of the method
         * reporting the exception, different methods that report the same exception may
         * provide different data in the exception. The documentation for each each method
         * will describe what, if any, data it provides for each exception it reports.
         * </p>
         * <p> The {@link com.vmware.vapi.std.errors.ArgumentLocations}, {@link
         * com.vmware.vapi.std.errors.FileLocations}, and {@link
         * com.vmware.vapi.std.errors.TransientIndication} classes are intended as possible
         * values for this property. {@link com.vmware.vapi.std.DynamicID} may also be
         * useful as a value for this property (although that is not its primary purpose).
         * Some interfaces may provide their own specific classes for use as the value of
         * this property when reporting exceptions from their methods.</p>
         *
         * Some methods will not set this property when reporting exceptions.
         *
         * @param data New value for the property.
         */
        public Builder setData(com.vmware.vapi.bindings.Structure data) {
            this.data = data;
            return this;
        }

        public InvalidArgument build() {
            InvalidArgument result = new InvalidArgument();
            result.setMessages(this.messages);
            result.setData(this.data);
            return result;
        }
    }


    static com.vmware.vapi.bindings.type.ErrorType __initStructType() {
        com.vmware.vapi.bindings.type.StructType.FieldNameDetails details = null;
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.Type> fields = new java.util.LinkedHashMap<java.lang.String, com.vmware.vapi.bindings.type.Type>();
        java.util.Map<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails> fieldNameDetails = new java.util.HashMap<java.lang.String, com.vmware.vapi.bindings.type.StructType.FieldNameDetails>();
        fields.put("messages", new com.vmware.vapi.bindings.type.ListType(new com.vmware.vapi.bindings.type.TypeReference<com.vmware.vapi.bindings.type.StructType>() { @java.lang.Override public com.vmware.vapi.bindings.type.StructType resolve() { return com.vmware.vapi.std.StructDefinitions.localizableMessage; } }));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("messages",
                                                                                "messages",
                                                                                "getMessages",
                                                                                "setMessages");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("data", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.DynamicStructType()));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("data",
                                                                                "data",
                                                                                "getData",
                                                                                "setData");
        fieldNameDetails.put(details.getCanonicalName(), details);
        fields.put("error_type", new com.vmware.vapi.bindings.type.OptionalType(new com.vmware.vapi.bindings.type.EnumType("com.vmware.vapi.std.errors.error.type", com.vmware.vapi.std.errors.Error.Type.class)));
        details = new com.vmware.vapi.bindings.type.StructType.FieldNameDetails("error_type",
                                                                                "errorType",
                                                                                "getErrorType",
                                                                                null);
        fieldNameDetails.put(details.getCanonicalName(), details);
        return new com.vmware.vapi.bindings.type.ErrorType("com.vmware.vapi.std.errors.invalid_argument",
                                                           fields,
                                                           com.vmware.vapi.std.errors.InvalidArgument.class,
                                                           fieldNameDetails);
    }
}

